#include <iostream>
#include <vector>
#include <algorithm>
#include <string>
#include <map>
#include <cstdio>
#include <utility> 
#include <queue>
#include <math.h>
#include <set>
#include <bitset>
#include <cmath>
#include <bitset>
#include <stack>
#include <cstring>
#include <math.h>
#include <iomanip>
#include <unordered_map>
#include <random>
#include <fstream>
#include <chrono>
using namespace std;
using namespace std::chrono;
typedef long long ll;
typedef pair<int, int> pii;

const int N = 4847581; // number of vertices
vector<pii> stream;
// dataset names
string dataset[5] = {"slash", "berkeley", "google", "pokec", "live"};
int vertices[5] = {82168, 685231, 916428, 1632804, 4847571};

double bahmaniAlg(double c, double ep, int n) {
	double S = n; // size of set S
	double T = n; // size of set T
	double totEdges = stream.size();
	double bestD = totEdges/sqrt(S * T); // best density so far
	vector<int> inS(n);
	vector<int> inT(n);
	vector<int> inDeg(n);
	vector<int> outDeg(n);
	while(S != 0 && T != 0) {
		if((double)S/(double)T >= c) {
			double avgD = totEdges/S;
			// Calculate out degree of each vertex
			for(pii e : stream) {
				if(inS[e.first] == 0 && inT[e.second] == 0)
					outDeg[e.first]++;
			}

			// Peeling
			for(int i = 0; i < n; i++) {
				if(inS[i] == 0 && outDeg[i] <= (1+ep)*avgD) {
					// Remove from set S
					inS[i] = 1;
					S--;
					totEdges -= outDeg[i];
				}
			}

			// Clear out degree for next iteration
			for(int i = 0; i < n; i++)
				outDeg[i] = 0;
		}
		else {
			double avgD = totEdges/T;
			// Calculate in degree of each vertex
			for(pii e : stream) {
				if(inS[e.first] == 0 && inT[e.second] == 0)
					inDeg[e.second]++;
			}

			// Peeling
			for(int i = 0; i < n; i++) {
				if(inT[i] == 0 && inDeg[i] <= (1+ep)*avgD) {
					// Remove from set T
					inT[i] = 1;
					T--;
					totEdges -= inDeg[i];
				}
			}

			// Clear out degree for next iteration
			for(int i = 0; i < n; i++)
				inDeg[i] = 0;
		}

		// Update best density
		totEdges = 0;
		for(pii e : stream) {
			if(inS[e.first] == 0 && inT[e.second] == 0)
				totEdges++;
		}
		if(S != 0 && T != 0) bestD = max(bestD, totEdges/sqrt(S*T));
	}
	return bestD;
}

vector<ll> durations;
double ourAlg(double c, double ep, int n) {
	double D = (double)stream.size()/(double)n;
	vector<int> bestS(n);
	vector<int> bestT(n);
	double S = 0;
	double T = 0;
	double bestD = 0;
	int idx = -1;
	while(D <= n) {
		idx++;
		double k1 = D/((double)2 * sqrt(c));
		double k2 = D * sqrt(c)/(double)2;
		vector<ll> ls(n);
		vector<ll> lt(n);
		vector<ll> ds(n);
		vector<ll> dt(n);
		ll maxl = 0;
		ll cnt = 0;
		auto start=high_resolution_clock::now();
		for(pii e : stream) {
			int u = e.first; int v = e.second;
			if(ls[u] <= lt[v]) ds[u]++;
			if(ls[u] >= lt[v]) dt[v]++;
			if(ds[u] >= k1) {
				ls[u]++; ds[u] = 0;
			}
			if(dt[v] >= k2) {
				lt[v]++; dt[v] = 0;
			}
			maxl = max(ls[u], max(lt[v], maxl));
			cnt++;
			if(cnt % 10000 == 0) {
				auto stop=high_resolution_clock::now();
				auto duration= duration_cast<microseconds>(stop - start);
				int id = cnt / 10000 - 1;
				if((int)durations.size() <= id) durations.push_back(duration.count());
				else durations[id] += duration.count();
				start=high_resolution_clock::now();
			}
		}
		double prevS = n;
		double prevT = n;
		vector<int> inS(n);
		vector<int> inT(n);
		for(int i = 1; i <= maxl + 1; i++) {
			double currS = 0;
			double currT = 0;
			for(int j = 0; j < n; j++) {
				if(ls[j] >= i) currS++;
				else inS[j] = 1;
				if(lt[j] >= i) currT++;
				else inT[j] = 1;
			}
			if(currS == 0 || currT == 0) {
				prevS = 0; break;
			}
			if(currS/currT >= c && currS >= prevS/(maxl)) {
				prevS = currS;
				prevT = currT;
				break;
			}
			else if(currS/currT <= c && currT >= prevT/(maxl)) {
				prevS = currS;
				prevT = currT;
				break;
			}
			prevS = currS;
			prevT = currT;
			//if(i == maxl) cout << D << '\n';
		}
		if(prevS == 0 || prevT == 0) break;
		bestS = inS;
		bestT = inT;
		S = prevS;
		T = prevT;
		D *= 2;
	}
	if(S == 0 || T == 0) return 0;
	double edges = 0;
	for(pii e : stream) {
		if(bestS[e.first] == 0 && bestT[e.second] == 0) edges++;
	}
	return edges/sqrt(S*T);
}

void runDS(int z) {
	string name = dataset[z];
	cout << name << ":" << endl;
	ifstream data(name + ".txt");
	stream.clear();

	int n = vertices[z];

	// Construct graph
	int x;
    while(data >> x) {
    	int y; data >> y;
    	stream.push_back(pii(x, y));
    }
    
    // Randomize stream
    /*random_device rd;
    mt19937 gen(rd());
    shuffle(stream.begin(), stream.end(), gen);*/

    double ep = 0.2;
    double c = 1/(double)n;
    double delta = 1.2;
    // Run Bahmani
    ofstream bahmaniData("bdata-" + name + "-0.2.txt");
    double bahmaniDensity = 0;
    while(c <= n) {
    	cout << "c: " << c << '\n';
    	auto start=high_resolution_clock::now();
    	double val = bahmaniAlg(c, ep, n);
    	auto stop=high_resolution_clock::now();
    	auto duration = duration_cast<microseconds>(stop - start);

    	bahmaniData<<c<<" "<<val<<" "<<duration.count()<<'\n';
    	//cout << "bahmani density: " << val <<" "<<duration.count() <<'\n';
    	bahmaniDensity = max(bahmaniDensity, val);
    	c *= delta;
    }
    cout << "best Bahmani Density: " << bahmaniDensity << '\n';

    // Run our algorithm
    ofstream ourData("ourdata-" + name + "-time-1.txt");
    double ourDensity = 0;
    c = 1/(double)n;
    while(c <= n) {
    	cout << "c: " << c << '\n';
    	auto start=high_resolution_clock::now();
    	double val = ourAlg(c, ep, n);
    	auto stop=high_resolution_clock::now();
    	auto duration= duration_cast<microseconds>(stop - start);
    	cout << "our density: " << val << " " << duration.count() << '\n';
    	/*for(ll i = 0; i < durations.size(); i++) {
    		ourData << (ll)10000*(i+1) << " " << durations[i] << '\n';
    	}*/
    	ourData<<c<<" "<<val<<" "<<duration.count()<<'\n';
    	ourDensity = max(ourDensity, val);
    	durations.clear();
    	c *= delta;
    }
    cout << "best Our Density: " << ourDensity << '\n';
}

int main() {
	ios_base::sync_with_stdio(0);
    cin.tie(NULL);
    
    for(int i = 0; i < 5; i++) {
    	runDS(i);
    }
}
